let sort_indexed (k_1,_) (k_2,_) =
  if k_1 < k_2 then ~-1
  else if k_1 = k_2 then 0
  else 1

let sort_sorted (_,i_1) (_,i_2) =
  if i_1 < i_2 then ~-1
  else if i_1 = i_2 then 0
  else 1

let indicator b = if b then 1 else 0

let k_to_v k_vector =
  let min_cost = Array.fold_left (fun x v -> min x v) max_float k_vector in
  let indexed_k = Array.mapi (fun i k -> (k -. min_cost, i) ) k_vector in
  Array.sort sort_indexed indexed_k;
  let indexed_v = Array.copy indexed_k in
  let integral = ref 0. 
  and old_k = ref 0. in
  for i = 0 to Array.length indexed_k - 1 do
    let new_k,new_index = indexed_k.(i) in
    let new_integral = !integral +. (new_k -. !old_k) *. (float (i-1)) in
    indexed_v.(i) <- (new_integral, new_index);
    old_k := new_k;
    integral := new_integral
  done;
  Array.sort sort_sorted indexed_v;
  Array.map (fun (v,i) -> v) indexed_v
  
let label_number = ref 2
  
let make_classifiers iw_classifier _ samples = 
  let samples = List.map (fun (x,costs) -> (x, Io.string_to_costs costs)) samples in
  let number_of_labels = Array.length (snd (List.hd samples)) 
  and samples = List.map (fun (x,c) -> x,k_to_v c) samples
  and ret = ref [] in
  
  for i = 1 to number_of_labels do
    for j = i+1 to number_of_labels do
      let samples = 
	List.map 
	  (fun (x,vs) -> x, string_of_int (indicator (vs.(i) < vs.(j))), 
	    string_of_float (abs_float (vs.(i) -. vs.(j)))) 
	  samples in
      ret := (iw_classifier samples, (i,j)) :: !ret
    done
  done;
  label_number := number_of_labels;
  !ret
      
let classify classifiers features = 
  let win_counts = Array.create !label_number 0 in
  
  List.iter (fun ((ic,oc),(i,j)) -> 
    output_string oc (features^"\n\n");
    flush oc;
    let return_bit = "1" = input_line ic in
    if return_bit 
    then win_counts.(i) <- win_counts.(i) + 1
    else win_counts.(j) <- win_counts.(j) + 1
	    ) classifiers;
  
  let max_val = ref min_int
  and max_loc = ref 0 in
  Array.iteri (fun i v -> 
    if v > !max_val 
    then begin
      max_val := v;
      max_loc := i;
    end) win_counts;
  output_string stdout (string_of_int (!max_loc)^"\n");
  flush stdout
    
let _ =
  Common.batch_reduction "wap" Io.iw_classifier make_classifiers classify
