let make_classifiers iw_classifier num_iter samples = 
  let intervals = ref [] in
  let classifiers = ref [] in
  for i = 1 to num_iter do
    let p = float i /. float (1+ num_iter)
    and old_p = float (i-1) /. float (1 + num_iter) in
    let weight = string_of_float (1. -. p /. p) in
    let weighted_samples = List.map (fun (y,x) -> 
      if y = "1" 
      then (x,y,weight)
      else (x,y,"1")) samples in
    
    classifiers := (iw_classifier weighted_samples, (old_p,p)) ::!classifiers;
  done;
  intervals := (float num_iter /. float (num_iter + 1), 1.) :: !intervals;
  List.rev !classifiers
    
let prob classifiers input = 
  let (classifiers,intervals) = List.split classifiers in
  let intervals = Array.of_list intervals in
  let total = 
    List.fold_left (fun v (ic,oc) -> 
      let data = Io.query_classifier (ic,oc) input in
      v + int_of_string data
		   ) 0 classifiers in
  let (low,high) = intervals.(total) in
  output_string stdout ((string_of_float ((high +. low) /. 2.))^"\n")
    
let _ =
  Common.batch_reduction "probing" Io.iw_classifier make_classifiers prob
