(*  Method: Pick a random subset. *)
let label_set = ref ([||] : string array)
    
let make_classifiers prob_classifier classifier_number samples = 
  let labels = List.fold_left (fun labels (_,label) -> if List.mem label labels then labels else label::labels) [] samples in
  let number_of_labels = List.length labels in
  
  let label_to_int = Hashtbl.create number_of_labels in
  label_set := Array.of_list labels;
  Array.iteri (fun i label -> Hashtbl.add label_to_int label i) !label_set;

  let samples = List.map (fun (x,label) -> (x,Hashtbl.find label_to_int label)) samples in

  let classifier_number = 
    if classifier_number = 0 
    then int_of_float (8. *. log (float number_of_labels)) 
    else classifier_number in

  Array.to_list (Array.init classifier_number 
		   (fun _ -> 
		     let subset = Common.choose_subset number_of_labels in
		     let samples = 
		       List.map (fun (features,label) -> 
			 let bin_label = 
			   if subset.(label-1) 
			   then "1"
			   else "0" in
			 features,bin_label
				) samples in
		     prob_classifier samples, subset))
      
let classify classifiers features = 
  let prob_sum = Array.map (fun _ -> 0.) !label_set in
  
  List.iter (fun ((ic,oc),subset) -> 
    let prob = float_of_string (Io.query_classifier (ic,oc) features) in
    Array.iteri (fun i in_bit -> 
      if in_bit 
      then prob_sum.(i) <- prob_sum.(i) +. prob
      else prob_sum.(i) <- prob_sum.(i) +. 1. -. prob
		) subset 
	     ) classifiers;
  
  let max_val = ref min_float
  and max_loc = ref 0 in
  Array.iteri (fun i v -> 
    if v > !max_val 
    then begin
      max_val := v;
      max_loc := i;
    end) prob_sum;
  output_string stdout (!label_set.(!max_loc)^"\n");
  flush stdout

let _ =
  Common.batch_reduction "pecoc" Io.classifier make_classifiers classify
