let classifier = ref ""

let _ = 
  try
    Io.parse [] (fun x -> classifier := x) "usage: debug_io program";
    
    let (ci,co) = Unix.open_process !classifier in
    Unix.set_close_on_exec (Unix.descr_of_out_channel co);
    Unix.set_close_on_exec (Unix.descr_of_in_channel ci);
    
    let first_space = String.index !classifier ' ' in
    let prog_name = String.sub !classifier 0 first_space in
    
    while true do
      let features,label_data = Io.safe_input [] in
      output_string stderr (prog_name^" input features: "^features^"\n");
      output_string stderr (prog_name^" input label_data: "^label_data^"\n");
      flush stderr;
      output_string co (features^"\n");
      output_string co (label_data^"\n");
      flush co;
      match label_data with
	"" -> (* must do return value *)
	  let return = input_line ci in
	  output_string stderr (prog_name^" output: "^return^"\n");
	  flush stderr;
	  output_string stdout (return^"\n");
	  flush stdout;
      | _ -> ()
    done 
  with f -> 
    output_string stderr "debug_io: ";
    raise f
