(*  Method: Pick a random subset.  Pick a random threshold. *)
let make_classifiers iw_classifier classifier_number samples = 
  let samples = List.map (fun (x,costs) -> (x, Io.string_to_costs costs)) samples in
  let number_of_labels = Array.length (snd (List.hd samples)) in
  
  let classifier_number = 
    if classifier_number = 0 
    then int_of_float (8. *. log (float number_of_labels)) 
    else classifier_number in
      
  Array.to_list (Array.init classifier_number 
		   (fun _ -> 
		     let subset = Common.choose_subset number_of_labels 
		     and probability = Random.float 1. in
		     let iw_samples = 
		       List.map (fun (features,costs) -> 
			 let min_cost = Array.fold_left (fun x v -> min x v) max_float costs in
			 
			 let tot_in = ref 0.
			 and tot_out = ref 0. in
			 Array.iteri (fun i c -> 
			   if subset.(i) = true 
			   then tot_in := !tot_in +. c -. min_cost
			   else tot_out := !tot_out +. c -. min_cost) costs;
			 
			 let label = 
			   if !tot_in /. (!tot_in +. !tot_out) > probability 
			   then "1"
			   else "0" in
			 
			 let weight = !tot_in +. !tot_out in
			 features,label,string_of_float weight
				) samples in
		     iw_classifier iw_samples, subset))
      
let classify classifiers features = 
  let expected_costs = Array.map (fun _ -> 0.) (snd (List.hd classifiers)) in
  
  List.iter (fun ((ic,oc),subset) -> 
    let return_bit = "1" = Io.query_classifier (ic,oc) features in
    Array.iteri (fun i in_bit -> 
      if in_bit & return_bit or not in_bit & not return_bit
      then expected_costs.(i) <- expected_costs.(i) +. 1.
		) subset 
	     ) classifiers;
  
  let min_val = ref max_float
  and min_loc = ref 0 in
  Array.iteri (fun i v -> 
    if v < !min_val 
    then begin
      min_val := v;
      min_loc := i;
    end) expected_costs;
  output_string stdout (string_of_int (!min_loc)^"\n");
  flush stdout

let _ =
  Common.batch_reduction "csecoc" Io.iw_classifier make_classifiers classify
