let make_classifiers classifier num_iter examples = 
  let regexp = Str.regexp "[ \t]" in
  let examples = List.map (fun (x,li) -> 
    let li = Str.split regexp li in
    (float_of_string (List.hd (List.tl li)), List.hd li, x)) examples in

  let meta_class = ref [] in
  let max_importance = List.fold_left (fun m (i,y,x) -> max i m) 0. examples in
  
  for i = 0 to num_iter - 1 do
    let subsample = 
      List.filter (fun (i,y,x) -> Random.float max_importance <= i) examples in
    let subsample = List.map (fun (i,y,x) -> x, y) subsample in
    meta_class := (classifier subsample,()):: !meta_class
  done;
  !meta_class

let classify meta_class input = 
  let total = 
    List.fold_left (fun v ((ic,oc),_) -> 
      let data = Io.query_classifier (ic,oc) input in
      v + int_of_string data
		   ) 0 meta_class in
  let output = if total <= (List.length meta_class) / 2 then 0 else 1 in
  output_string stdout ((string_of_int output)^"\n")
    
let _ = 
  Common.batch_reduction "costing" Io.classifier make_classifiers classify  
