let left = '+'
let right = '-'

let parse speclist anonymous return =
  let new_argv = Array.create (Array.length Sys.argv) "" in
  let new_arg_point = ref 0 in
  let plus_count = ref 0 in

  for i = 0 to Array.length Sys.argv - 1 do (* group things at the lowest level only. *)
    if Sys.argv.(i).[0] = left 
    then incr plus_count;
    if !plus_count > 0 
    then new_argv.(!new_arg_point) <- new_argv.(!new_arg_point)^" "^Sys.argv.(i)
    else new_argv.(!new_arg_point) <- Sys.argv.(i); 

    if Sys.argv.(i).[String.length Sys.argv.(i) - 1] = right
    then plus_count := max (!plus_count -1) 0; 

    if !plus_count <= 0 
    then incr new_arg_point
  done;
  if !plus_count > 0 
  then incr new_arg_point;
  let new_argv = Array.sub new_argv 0 !new_arg_point in
  let new_argv = Array.map (fun x -> 
    if String.length x < 2
    then x
    else
      if x.[1] <> left
      then x
      else 
	let x = String.sub x 2 (String.length x - 2) in
	if x.[String.length x - 1] <> right
	then x 
	else String.sub x 0 (String.length x - 1)
			   ) new_argv in
  Arg.parse_argv new_argv speclist anonymous return

let query_classifier (ic,oc) features =
  output_string oc (features^"\n\n");
  flush oc;
  input_line ic

let safe_input classifiers =
  try
    let features = input_line stdin
    and target_info = input_line stdin in
    features, target_info
  with 
    End_of_file -> 
      List.iter (fun (ic,oc) -> close_out oc; close_in ic) classifiers;
      exit 0
    
let iw_classifier program samples = 
  let (ic,oc) = Unix.open_process program in
  Unix.set_close_on_exec (Unix.descr_of_out_channel oc);
  Unix.set_close_on_exec (Unix.descr_of_in_channel ic);
  List.iter (fun (obs, label, importance) -> 
    output_string oc (obs^"\n");
    output_string oc (label^" "^importance^"\n");
	    ) samples;
  flush oc;
  (ic,oc) 

let classifier program samples = 
  let (ic,oc) = Unix.open_process program in
  Unix.set_close_on_exec (Unix.descr_of_out_channel oc);
  Unix.set_close_on_exec (Unix.descr_of_in_channel ic);
  List.iter (fun (obs, label) -> 
    output_string oc (obs^"\n");
    output_string oc (label^"\n");
	    ) samples;
  flush oc;
  (ic,oc)

let whitespace = Str.regexp "[ \t]"
    
let string_to_costs costs = 
  Array.of_list (List.map (fun s -> float_of_string s) (Str.split whitespace costs))
    
