let rec choose_subset number_of_labels = 
  let candidate = Array.init number_of_labels (fun _ -> Random.int 2 > 0) in
  if Array.fold_left (fun carry bit -> carry & bit) true candidate
      or not (Array.fold_left (fun carry bit -> carry or bit) false candidate)
  then choose_subset number_of_labels
  else candidate

let batch_reduction name oracle_classifier reduction reduction_classifier =
  try 
    let classifier_number = ref 0 in
    Random.init (input_binary_int (open_in_bin "/dev/urandom"));
    let arguments = ref [] in
    Io.parse 
      ["-num", Arg.Int (fun x -> classifier_number := x), "number of base classifiers"] 
      (fun x -> arguments := x::!arguments)
      ("usage: "^name^" oracle_classification_algorithm");
    
    if List.length !arguments <> 1
    then begin
      output_string stderr (name^"pecoc wrong number of arguments\n");
      exit 1;
    end;
    
    let samples = ref [] in
    let first_time = ref true in
    let classifiers = ref [] in
    let pure_classifiers = ref [] in
    
    while true do
      let features,data = Io.safe_input !pure_classifiers in
      if data <> ""
      then
	samples := (features,data)::!samples
      else 
	if !first_time 
	then begin
	  first_time := false;
	  classifiers := 
	    reduction (oracle_classifier (List.hd !arguments)) 
	      !classifier_number (List.rev !samples);
	  pure_classifiers := fst (List.split !classifiers);
	  reduction_classifier !classifiers features
	end
	else 
	  reduction_classifier !classifiers features
    done
      
  with 
    f -> output_string stderr (name^": "); raise f


    
