let scale = 1. /. 1000.

exception Interrupt
exception Bug

let args = ref [] 
let usage = 
  "progressive_validation <bound_failure_probability> <number_of_rounds> <number_of_errors>"

let _ =
  Arg.parse [] (fun x -> args := x:: !args) usage;
  let args = List.rev !args in
  if List.length args <> 3
  then print_string (usage^"\n")
  else 
    let delta = float_of_string (List.hd args) 
    and rounds = int_of_string (List.hd (List.tl args)) 
    and errors = int_of_string (List.hd (List.tl (List.tl args))) in
    let bins = int_of_float (float rounds /. scale)
    and bet_number = int_of_float (1. /. scale) in
    let tiny =  delta *. 0.0001 in

    let f = Array.init (1 + min errors rounds)
	(fun j ->
	  Array.create ((rounds+3) * bet_number + 1) tiny) in
    for  j = 0 to min errors rounds do
      for k = 0 to bet_number do (* index over function value. *)
	f.(j).(k) <- 1.
      done
    done;
    let p = Array.init (bet_number+1) (fun i -> float (i-1) *. scale) in
    let minus_p = Array.map (fun x -> 1. -. x) p in
    let prev_f = Array.map Array.copy f in
    for round = 1 to rounds do (* round *)
      for err = 0 to min round errors do
	let prev_f_err = prev_f.(err) 
	and prev_f_minus_err = prev_f.(err-1) in 
	begin try
	  for k = bet_number + 1 to bet_number * (round+1) do
	    let max_bet_val = ref 0. in
	    if round = err 
	    then 
	      for q = 1 to bet_number do
		let expected_value = 
		  minus_p.(q) *. prev_f_minus_err.(k - q) 
		    +. p.(q) *. prev_f_minus_err.(k - q + bet_number) in
		if expected_value > !max_bet_val 
		then max_bet_val := expected_value;
	      done
	    else if err = 0 
	    then 
	      for q = 1 to bet_number do
		let expected_value = minus_p.(q) *. prev_f_err.(k - q) in
		if expected_value > !max_bet_val 
		then max_bet_val := expected_value;
	      done
	    else
	      for q = 1 to bet_number do
		let expected_value = 
		  minus_p.(q) *. prev_f_err.(k - q) 
		    +. p.(q) *. prev_f_minus_err.(k - q + bet_number) in
		if expected_value > !max_bet_val 
		then max_bet_val := expected_value;
	      done;
	    f.(err).(k) <- !max_bet_val;
	    if !max_bet_val < tiny *. 2. 
	    then raise Interrupt;
	  done
	with
	  Interrupt -> () end;
	try 
	  for k = 0 to Array.length f.(err)-1 do
	    if f.(err).(k) < delta 
	    then 
	      (print_string (string_of_int round^" "^string_of_int err^" "
			     ^string_of_float (float k *. scale -. 1.)^"\n");
	       flush stdout;
	       raise Interrupt)     
	  done;
	with Interrupt -> ()
      done;
      Array.iteri 
	(fun err f_at_err -> 
	  prev_f.(err) <- f_at_err;
	  f.(err) <- Array.copy prev_f.(err)
	) f;
    done
