#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char* argv[])
{
  if (argc != 5)
    {
      printf("usage: pv_bound <bound_failure_probability> <number_of_rounds> <batch_size> <number_of_errors>\n");
      printf(" you used %i arguments\n",argc);
      return 1;
    }
  float delta;
  int rounds;
  int batch_size;
  int errors;

  sscanf(argv[1],"%f",&delta);
  sscanf(argv[2],"%i",&rounds);
  sscanf(argv[3],"%i",&batch_size);
  sscanf(argv[4],"%i",&errors);

  if (rounds * batch_size < errors) 
    {
      printf("number of errors must be less than number of rounds * batch_size\n");
      return 1;
    }

  float number_of_examples = (float) (batch_size * rounds);
  float error_rate = (float) errors / number_of_examples;
  
  float analytic = error_rate + sqrt(log(1. / delta) / number_of_examples);
  
  float log_term = log ((number_of_examples + 1.) * 2. / delta);
    
  float analytic_2 = error_rate + 12. / number_of_examples * log_term + sqrt(4 * error_rate * log_term);
  
  printf("analytic = ");
  if (analytic > analytic_2) 
    printf("%f\n", analytic_2);
  else
    printf("%f\n", analytic);    

  float tiny = delta * 0.00001;

  int start = - logf(analytic) / logf(2.);
  
  for (int s = start; s <= 20; s++)
    {
      float scale = powf(0.5, s);

      int bet_number =  (int) powf(2.,s);
      int max_k = rounds * batch_size * bet_number - 1;
      
      float **f = (float **) malloc(sizeof (float*) * (1+errors));
      float **prev_f = (float **) malloc(sizeof (float*) * (1+errors));;
      for (int j = 0; j <= errors; j++)
	{
	  f[j] = (float *) malloc(sizeof(float) * max_k + 1);
	  prev_f[j] = (float *) malloc(sizeof(float) * max_k + 1);
	  for (int i = 0; i <= max_k; i++)
	    prev_f[j][i] = 0.;
	  prev_f[j][0] = 1.;
	  f[j][0] = 1.;
	}
      
      for (int round = 1; round <= rounds; round++)
	{
	  int bound = errors;
	  if (bound > round * batch_size) 
	    bound = round * batch_size;
	  for (int err = 0; err <= bound; err++)
	    {
	      int ebound = err;
	      if (batch_size < ebound)
		ebound = batch_size;
	      for (int k = 1; k <= max_k; k++)
		{
		  float max_bet_val = prev_f[err][k];
		  for (int bet = 1; bet < bet_number; bet++)
		    {
		      float p = bet * scale;
		      float expected_value = 0.;
		      
		      float choose = 1.;
		      float p_to_i = 1.;
		      float minus_p_to_batch_size_minus_i = powf(1. - p, batch_size);
		      float inv_minus_p = 1. / (1. - p);
		      int index = k - (int) (bet_number * p * batch_size) - 1;
		      
		      for (int i = 0; i <= ebound; i++)
			{
			  float v = 0. ;
			  if (index < 0)
			    v = 1.;
			  else if (index < max_k)
			    v = prev_f[err - i][index];
			  
			  expected_value += choose * minus_p_to_batch_size_minus_i * p_to_i * v;
			  choose *= (batch_size - i) / ((float) i+1);
			  p_to_i *= p;
			  minus_p_to_batch_size_minus_i *= inv_minus_p;
			  index += bet_number;
			}//expectation
		      if (expected_value > max_bet_val)
			max_bet_val = expected_value;
		    }//bet
		  f[err][k] = max_bet_val;
		  if (max_bet_val < tiny)
		    break;
		}//k
	    }//err
	  for (int err = 0; err <= bound; err++)
	    {
	      float *temp = prev_f[err];
	      prev_f[err] = f[err];
	      f[err] = temp;
	    }
	}//round
      for (int k = 1; k <= max_k; k++)
	{
	  if (prev_f[errors][k] < delta)
	    {
	      printf("%f\ts = %f\n", 
		     ((float) errors + ((float) k) * scale) / ((float) rounds * batch_size),
		     (float) scale);
	      fflush(stdout);
	      break;
	    }
	}
    }//s
  return 0;
}


