exception Interrupt

let args = ref [] 
let usage = 
  "progressive_validation <bound_failure_probability> <number_of_rounds> <batch_size> <number_of_errors>"

let _ =
  Arg.parse [] (fun x -> args := x :: !args) usage;
  let args = List.rev !args in
  if List.length args <> 4
  then (print_string (usage^"\n"); exit 1)
  else 
    let delta = float_of_string (List.hd args) 
    and rounds = int_of_string (List.hd (List.tl args)) 
    and batch_size = int_of_string (List.hd (List.tl (List.tl args))) 
    and errors = int_of_string (List.hd (List.tl (List.tl (List.tl args)))) in

    if rounds*batch_size < errors 
    then (print_string "number of errors must be less than number of rounds + 1\n"; exit 1);
    
    let tiny = delta *. 0.00001 in
    
    for s = 1 to 20 do
      let scale = 1. /. (2. ** float s) in
      let bet_number = int_of_float (1. /. scale) in 
      let max_k = rounds * batch_size * bet_number - 1 in
      
    (* f = the maximum probability of achieving a deviation with some number of errors. *)
      let f = Array.init (1 + errors) 
	  (fun j -> (* We discretize the universe into discrete deviations. *)
	    Array.create (max_k + 1) 0.) in
      
      for i = 0 to errors do
	f.(i).(0) <- 1.
      done;
      
      let prev_f = Array.map Array.copy f in
      
    (* round 0 is meaningless *)
      for round = 1 to rounds do (* for each round *)
	for err = 0 to min errors (round * batch_size) do (* for each number of errors *)
	  begin try
	    for k = 1 to max_k do (* for each deviation *)
	      let max_bet_val = ref prev_f.(err).(k) in
	      for bet = 1 to bet_number - 1 do (* Make a bet of some discretized size.*)
		let p = float bet *. scale 
		and expected_value = ref 0. 
		and choose = ref 1. in
		for i = 0 to min batch_size err do
		  let index = k +
		      int_of_float (float bet_number *. ( float i -. (p *. float batch_size))) -1 in
		  let v = 
		    if index < 0 then 1. 
		    else if index > max_k then 0. 
		    else prev_f.(err - i).(index) in
		  
		  expected_value := !expected_value +. !choose *. (1. -. p) ** float (batch_size - i) *. p ** (float i) *. v;
		  choose := !choose *. float (batch_size - i) /. float (i + 1);
		done;
		if !expected_value > !max_bet_val 
		then max_bet_val := !expected_value
	      done;
	      f.(err).(k) <- !max_bet_val; (* Assign the max probability bet to f.*)
	      if !max_bet_val < tiny 
	      then raise Interrupt;
	    done
	  with
	    Interrupt -> () end;
	  
	done;
	
	Array.iteri 
	  (fun err f_at_err -> 
	    prev_f.(err) <- f_at_err;
	    f.(err) <- Array.copy prev_f.(err)
	  ) f;
      done;
      
      begin try 
	for k = 0 to Array.length f.(errors)-1 do
	  if f.(errors).(k) < delta
	  then (* Output the first point with probability less than delta at err. *)
	    (print_string (string_of_float (float errors /. float rounds /. float batch_size +. float k *. scale /. float rounds /. float batch_size));
	     print_string ("\ts = 2^-"^string_of_int s^"\n");
	     flush stdout;
	     raise Interrupt)     
	done;
      with Interrupt -> () end;
	  
    done
      
