let scale = 1. /. 1000.
let rounds = 10
let distance = float rounds

let bins = int_of_float (distance /. scale)
let bet_number = int_of_float (1. /. scale)

exception Interrupt
exception Bug

let _ =
  let f = Array.init (rounds+1)
      (fun i -> Array.create ((i+3) * bet_number + 1) 0.) in
  let max_bets = Array.init (rounds+1) 
      (fun i -> Array.create ((i+3) * bet_number + 1) 0 ) in
  for i = 0 to rounds do (* index over rounds. *)
    for k = 0 to bet_number do (* index over function value. *)
      f.(i).(k) <- 1.
    done
  done;
  for round = 1 to rounds do (* round *)
    let previous_f = f.(round-1) in
    try
      (* Bin j covers [j * scale, j * scale +1) *)
      for k = bet_number +1 to bet_number * (round+1) do
	let max_bet_val = ref previous_f.(k) in
	let max_bet = ref 0 in
	(* We can bet any quantity from 0 to 1 in increments of 1/scale. *)
	for q = 1 to bet_number do
	  (* To upper bound the chance of success, we use the upper bound on the value of 
	     an interval and an upper bound on the probability of reaching that interval.
	   *)
	  let lower_value = previous_f.(k - q)  
	  and upper_value = previous_f.(k - q + bet_number) in
	  let lower_prob = 1. -. float (q-1) *. scale
	  and upper_prob = float (q-1) *. scale in
	  let expected_value = lower_value *. lower_prob +. upper_value *. upper_prob in
	  if expected_value > !max_bet_val 
	  then begin
	    max_bet_val := expected_value;
	    max_bet := q;
	  end
	done;
	f.(round).(k) <- !max_bet_val;
	max_bets.(round).(k) <- !max_bet;
	if !max_bet_val = 0. then raise Interrupt;
      done
    with
      Interrupt -> ()
  done;
  
  for i = 0 to rounds do
    let oc = open_out (string_of_int i) in
    for j = 0 to Array.length f.(i)-1 do
      output_string oc (string_of_float (float j *. scale -. 1.)^"\t"
			^string_of_float f.(i).(j)^"\t"
			^string_of_float (float_of_int max_bets.(i).(j) *. scale)^"\n");
    done;
    close_out oc;
  done

