let scale = 1. /. 1000.

exception Interrupt

let args = ref [] 
let usage = 
  "progressive_validation <bound_failure_probability> <number_of_rounds> <number_of_errors>"

let _ =
  Arg.parse [] (fun x -> args := x:: !args) usage;
  let args = List.rev !args in
  if List.length args <> 3
  then (print_string (usage^"\n"); exit 1)
  else 
    let delta = float_of_string (List.hd args) 
    and rounds = int_of_string (List.hd (List.tl args)) 
    and errors = int_of_string (List.hd (List.tl (List.tl args))) in

    if rounds < errors 
    then (print_string "number of errors must be less than number of rounds + 1\n"; exit 1);
    
    let bins = int_of_float (float rounds /. scale)
    and bet_number = int_of_float (1. /. scale) in
    let tiny =  delta *. 0.0001 in

    (* f = the maximum probability of achieving a deviation with some number of errors.
     *)
    let f = Array.init (1 + errors) 
	(fun j -> (* We discretize the universe into discrete deviations. *)
	  Array.create ((rounds+3) * bet_number + 1) tiny) in

    for  j = 0 to errors do
      for k = 0 to bet_number do  
        (* The first bet_number entries are the base case where we have already achieved the 
	 deviation.*)
	f.(j).(k) <- 1.
      done
    done;

    let p = Array.init (bet_number+1) (fun i -> float (i-1) *. scale) in
    let minus_p = Array.map (fun x -> 1. -. x) p in

    let prev_f = Array.map Array.copy f in

    print_string "round\terrs\tdev\n";
    (* round 0 is meaningless *)
    for round = 1 to rounds do (* for each round *)
      for err = 0 to errors do (* for each number of errors *)
	begin try
	  for k = bet_number + 1 to bet_number * (round+1) do (* for each deviation *)
	    let max_bet_val = ref 0. in
	    if round = err (* boundary case *)
	    then 
	      for q = 1 to bet_number do
		let expected_value = 
		  minus_p.(q) *. prev_f.(err - 1).(k - q) 
		    +. p.(q) *. prev_f.(err - 1).(k - q + bet_number) in
		if expected_value > !max_bet_val 
		then max_bet_val := expected_value;
	      done
	    else if err = 0 (* boundary case *)
	    then 
	      for q = 1 to bet_number do
		let expected_value = minus_p.(q) *. prev_f.(err).(k - q) in
		if expected_value > !max_bet_val 
		then max_bet_val := expected_value;
	      done
	    else
	      for q = 1 to bet_number do (* Make a bet of some discretized size.*)
		let expected_value = 
		  minus_p.(q) *. prev_f.(err).(k - q) 
		    +. p.(q) *. prev_f.(err - 1).(k - q + bet_number) in
		if expected_value > !max_bet_val 
		then max_bet_val := expected_value;
	      done;
	    f.(err).(k) <- !max_bet_val; (* Assign the max probability bet to f.*)
	    if !max_bet_val < tiny *. 2. 
	    then raise Interrupt;
	  done
	with
	  Interrupt -> () end;

	try 
	  for k = 0 to Array.length f.(err)-1 do
	    if f.(err).(k) < delta  
	    then (* Output the first point with probability less than delta at err. *)
	      (print_string (string_of_int round^"\t"^string_of_int err^"\t"
			     ^string_of_float (float k *. scale -. 1.)^"\n");
	       flush stdout;
	       raise Interrupt)     
	  done;
	with Interrupt -> ()
      done;

      Array.iteri 
	(fun err f_at_err -> 
	  prev_f.(err) <- f_at_err;
	  f.(err) <- Array.copy prev_f.(err)
	) f;
    done
