let scale = 1. /. 1000.

exception Interrupt
exception Bug

let args = ref [] 
let usage =     "progressive_validation <bound_failure_probability> <number_of_rounds>"

let _ =
  Arg.parse [] (fun x -> args := x:: !args) usage;
  let args = List.rev !args in
  if List.length args <> 2 
  then print_string (usage^"\n")
  else 
    let delta = float_of_string (List.hd args) 
    and rounds = int_of_string (List.hd (List.tl args)) in
    let bins = int_of_float (float rounds /. scale)
    and bet_number = int_of_float (1. /. scale) in
    
    let f = Array.init (rounds+1)
	(fun i -> Array.create ((i+3) * bet_number + 1) 0.) in
    let max_bets = Array.init (rounds+1) 
	(fun i -> Array.create ((i+3) * bet_number + 1) 0 ) in
    for i = 0 to rounds do (* index over rounds. *)
      for k = 0 to bet_number do (* index over function value. *)
	f.(i).(k) <- 1.
      done
    done;
    for round = 1 to rounds do (* round *)
      let previous_f = f.(round-1) in
      try
      (* Bin j covers [j * scale, j * scale +1) *)
	for k = bet_number +1 to bet_number * (round+1) do
	  let max_bet_val = ref previous_f.(k) in
	  let max_bet = ref 0 in
	(* We can bet any quantity from 0 to 1 in increments of 1/scale. *)
	  for q = 1 to bet_number do
	  (* To upper bound the chance of success, we use the upper bound on the value of 
	     an interval and an upper bound on the probability of reaching that interval.
	   *)
	    let lower_value = previous_f.(k - q)  
	    and upper_value = previous_f.(k - q + bet_number) in
	    let lower_prob = 1. -. float (q-1) *. scale
	    and upper_prob = float (q-1) *. scale in
	    let expected_value = lower_value *. lower_prob +. upper_value *. upper_prob in
	    if expected_value > !max_bet_val 
	    then begin
	      max_bet_val := expected_value;
	      max_bet := q;
	    end
	  done;
	  f.(round).(k) <- !max_bet_val;
	  max_bets.(round).(k) <- !max_bet;
	  if !max_bet_val = 0. then raise Interrupt;
	done
      with
	Interrupt -> ()
    done;
    
    for j = 0 to Array.length f.(rounds)-1 do
      if f.(rounds).(j) < delta 
      then 
	(print_string (string_of_float (float j *. scale -. 1.)^"\n"); 
	 exit 0)     
    done;

