#include "hypergeometric.h"
#include "binomial.h"
#include <iostream.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{
  if (argc < 6)
    {
      cerr << argv[0] << " <bound_error_rate> <number_of_train_examples> <number_of_train_errors> <transductive_bit_description_length> <unseen_test_set_size>\n";
      return 1;
    }
  else
    {
      int m = atoi(argv[2]);
      int n = atoi(argv[5]);
      int test_error_bound = hypergeometric_bound(m, n, atoi(argv[3]), atof(argv[4]), atof(argv[1]) / 2.);
      cout << orb_upper_bound(0.5, n, test_error_bound, 0.) << "\n";
      return 0;
    }
}
