#include <values.h>
#include "log_choose.h"
#include <math.h>
#include <iostream.h>

double bucket(int m, int n, int a, int b)
{
  double cumulative = MINDOUBLE;
  for(int j = b; j<=a+b; j++)
    if (j <= n) 
      cumulative = log_add(cumulative, (approx_log_choose(n,j) + approx_log_choose(m,(a+b-j))));
  cumulative = cumulative - approx_log_choose((n+m),(a+b));
  return cumulative;
}

int upper_bound_rec(double target, int m, int n, int a, int min, int max)
{
  if (max - min <= 1) return max;
  else
    {
      int mid = (max + min) / 2;
      double value = bucket(m,n,a,mid);
      if (value > target) return upper_bound_rec(target,m,n,a,mid,max);
      else return upper_bound_rec(target,m,n,a,min,mid);
    }
}

int hypergeometric_bound(int m, int n, int a, double bit_description_length, double confidence)
{
  if (a > m || n < 1 || m < 1 || a < 0) cerr << "invalid example or error number m = " 
					     << m << " n= " << n << " a = " << a << endl;
  else 
    if (confidence > 1. || confidence < 0.) cerr << "invalid confidence" << endl;
    else return upper_bound_rec(-bit_description_length * log(2.) + log(confidence), m, n, a, 0, n);
  return n;
}
