#include "log_choose.h"
#include <iostream.h>
#include <values.h>

//Calculate: n choose i * p^i (1-p)^(n-i)
double log_binom_coeff(int n, int i, double p)
{
  if (p == 0. || p == 1.) 
    if (p == 0.) 
      if (i == 0) return 0.; 
      else return MINDOUBLE;
    else 
      if (i == n) return 0.;
      else return MINDOUBLE;
  else
    {
      double fi = (double) i;
      return fi * log (p) + ((double) n - fi) * log (1. - p) + approx_log_choose(n,i);
    } 
}

double too_tiny = 0.00000000001;

//Calculate CDF 
double CDF(int n, int i, double p, double sum)
{
  if (i < 0) return sum;
  else 
    {
      double ret = log_add(log_binom_coeff(n, i, p), sum);
      if ( ret - sum > too_tiny || n * p < i) return CDF(n, i-1, p, ret);
      else return ret;
    }
}

//Search for upper or lower bounds
double upper_bound_rec(double target, int n, int i, double min, double max)
{
  if (max - min <= too_tiny) return max;
  else
    {
      double mid = (max + min) / 2;
      double value = CDF (n, i, mid, MINDOUBLE);
      if (value > target) return upper_bound_rec(target, n, i, mid, max);
      else return upper_bound_rec(target, n, i, min, mid);
    }
}

//The interfaces
//confidence = probability of bound failure.
//n = the number of examples
//i = the observed empirical error
//bit_length = the number of bits needed to describe this classifier
double orb_upper_bound(double confidence, int n, int i, double bit_length)
{
  if (i > n || i < 0 || n < 1) cerr << "invalid example or error count " << endl;
  else 
    if (confidence > 1. || confidence < 0.) cerr << "invalid confidence" << endl;
    else return upper_bound_rec(- bit_length * log(2.) + log(confidence), n, i, 0., 1.);
  return 1.;
}

double lower_bound(double confidence, int n, int i, double bit_length)
{
  return 1. - orb_upper_bound(confidence, n, n - i, bit_length);
}

int lower_bound_empirical_rec(double log_confidence, int n, double p, int k_under)
{
  if ( log_confidence > CDF(n, k_under, p, MINDOUBLE) || k_under == 0 ) 
    return k_under;
  else
    return lower_bound_empirical_rec(log_confidence, n, p, k_under--);
}

int lower_bound_empirical(double confidence, int n, double p)
{
  if ( p <= 0. || p >= 1. ) cerr << "invalid bias" << endl;
  else
    if ( confidence > 0.5 || confidence < 0. ) cerr << "invalid confidence" << endl;
    else return lower_bound_empirical_rec( log(confidence), n, p, (int) (((double) n) * p));
  return 0;
}

int upper_bound_empirical(double confidence, int n, double p)
{
  return n - lower_bound_empirical(confidence, n, 1. - p);
}
